<?php
  class WynikException extends Exception
  {
  }

  class Kontener
  {
    protected $tab = array(100, 200, 300, 400);
    public function getElement($index)
    {
      if(!is_numeric($index)){
        throw new InvalidArgumentException("Nieprawidłowy argument.");
      }
      $index = (integer) $index;
      if(!isSet($this->tab[$index])){
        throw new InvalidArgumentException("Nieprawidłowy argument.");
      }
      else{
        $exc = new WynikException("Wynikiem jest", $this->tab[$index]);
        throw $exc;
      }
    }
  }

  if($_SERVER['argc'] < 2){
    exit("W wywołaniu należy podać wartość indeksu!");
  }

  $kontener = new Kontener();

  $index = $_SERVER['argv'][1];

  try{
    $val = $kontener->getElement($index);
  }
  catch(InvalidArgumentException $e){
    echo "Wystąpił błąd: ", $e->getMessage();
    exit();
  }
  catch(WynikException $e){
    echo "Element o indeksie $index to ";
    echo $e->getCode();
  }
?>
